﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="n0" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title></title>
		<script runat="server">

    static bool procentInfo = false;
    static bool skladnikiInfo = false;
    static bool procentPit = false;
    //Włącza drukowanie podsumowania funduszy pożyczkowych. UWAGA! Informacja wg stanu
    //aktualnego a nie na dzień wypłaty.
    static bool funduszePożyczkowe = false;
    static bool daneFirmy = true;

    private void gridHeader_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        Wyplata wypłata = dc[typeof(Wyplata)] as Wyplata;

        WyplataEtat we = wypłata as WyplataEtat;
        Wyplata.ZUSInfoWorker zusinfo = new Wyplata.ZUSInfoWorker();
        zusinfo.Wypłata = wypłata;
        if (we != null)
            colPracInfo.EditValue = string.Format("PESEL: {0} Wymiar etatu: {1} Tytuł ubezpieczenia: {2}",
                wypłata.PracHistoria.PESEL,
                wypłata.PracHistoria.Etat.Zaszeregowanie.Wymiar,
                zusinfo.TytułUbezpieczenia/*wypłata.PracHistoria.Etat.Ubezpieczenia.Tyub*/);
        else {
            Umowa umowa = wypłata is WyplataUmowa ? ((WyplataUmowa)wypłata).Umowa : null;
            if (umowa != null)
                colPracInfo.EditValue = string.Format("PESEL: {0} Tytuł ubezpieczenia: {1}",
                    wypłata.PracHistoria.PESEL,
                    zusinfo.TytułUbezpieczenia/*umowa.Ubezpieczenia.Tyub*/);
            else
                colPracInfo.EditValue = string.Format("PESEL: {0}",
                    wypłata.PracHistoria.PESEL);
        }
    
        Currency ror = wypłata.Inne;
        colGotowka.EditValue = wypłata.WartoscCy-ror;
        colROR.EditValue = ror;

    }
    
    static readonly string prefix = "&nbsp;&nbsp;&nbsp;&nbsp;";
	private void gridElements_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        WypElement element = (WypElement)args.Row;

		if (!skladnikiInfo)	{
			if (element.Wartosc==0)
				args.VisibleRow = false;
			else {
				colNazwa.AddLine(element.Nazwa);
				WypSkladnikGłówny skg = element.SkładnikGłówny;
				colProcent.AddLine(skg==null ? Percent.Zero : skg.Procent);
				colCzas.AddLine(element.Czas);
				colDni.AddLine(element.Dni);
				AddWartosc(element.Wartosc);
			}
        }
		else 
			foreach (WypSkladnik sk in element.Skladniki) {
				WypSkladnikGłówny skg = sk as WypSkladnikGłówny;
				if (skg!=null) {
					colNazwa.AddLine(element.Nazwa);
					colProcent.AddLine(skg.Procent);
					colCzas.AddLine(skg.Czas);
					colDni.AddLine(skg.Dni);
					AddWartosc(skg.Wartosc);
				}
				else {
					WypSkladnikPomniejszenie skp = sk as WypSkladnikPomniejszenie;
					if (skp!=null) {
						colNazwa.AddLine(prefix + skp.Nieobecnosc.Definicja.Nazwa + " (" + skp.Okres + ")");
						colProcent.AddLine(skp.Procent);
						colCzas.AddLine(skp.Czas);
						colDni.AddLine(skp.Dni);
						colDodatek.AddLine(skp.Wartosc);
						colPotracenie.AddLine(0m);
					}
					else {
						colNazwa.AddLine(prefix + CaptionAttribute.EnumToString(sk.Rodzaj));
						colProcent.AddLine(sk.Procent);
						colCzas.AddLine(sk.Czas);
						colDni.AddLine(sk.Dni);
						colDodatek.AddLine(sk.Wartosc);
						colPotracenie.AddLine(0m);
					}
				}
			}            
    }
    
    void AddWartosc(decimal v) {
		if (v>=0) {
			colDodatek.AddLine(v);
			colPotracenie.AddLine(0m);
		}
		else {
			colDodatek.AddLine(0m);
			colPotracenie.AddLine(-v);
		}
    }
        
    private void dc_ContextLoad(object sender, System.EventArgs e) {
		if (!procentPit) {
			colPitInfo.Format = "";
			colPitProcent.DataMember = "";			
		}
		
        Wyplata wypłata = (Wyplata)dc[typeof(Wyplata)];
        gridHeader.DataSource = new object [] {new ContextObject(wypłata, dc.Context) };

			
		if(wypłata.Data.Year < 2022)
		{
			GridColumn90.Format = "Zdrow.do odlicz:";
			GridColumn100.DataMember = "Workers.PITInfo.ZdrowotneDoOdliczenia";
		}
		else {
				if(wypłata.ListaPlac.DataWyplaty < new Date(2022, 1, 1) || wypłata.ListaPlac.DataWyplaty >= new Date(2022, 7, 1))
				{
					GridColumn90.Format = "";
					GridColumn100.Format = "";
					GridColumn100.DataMember = "";
				} else{
					GridColumn90.Format = "Ulga klasa średnia";
					GridColumn100.DataMember = "Workers.PITInfo.UlgaKlasaSrednia";
				}
			}

		

		colProcent.Visible = procentInfo;
		
		ArrayList fundusze = new ArrayList();
		foreach (FundPozyczkowy f in wypłata.Pracownik.FunduszePozyczkowe)
			fundusze.Add(f);
	
		if (fundusze.Count==0 || !funduszePożyczkowe || !(wypłata is WyplataEtat))
			gridFundusze.Visible = false;
		else {
			ListWithView lvw = new ListWithView(fundusze, wypłata.Pracownik.Module.FundPozyczkowe.PrimaryKey);
			gridFundusze.DataSource = lvw;
		}

		if (daneFirmy) {
		    CoreModule core = CoreModule.GetInstance(dc);
            string nip = core.Config.Firma.Pieczątka.NIP;
            string regon = core.Config.Firma.Pieczątka.REGON;
            string nazwa = core.Config.Firma.Pieczątka.Nazwa;
            PracHistoria ph = wypłata.PracHistoria;
            if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
                if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            }
            colNazwaFirmy.Format = nazwa;
            colNIP.Format = nip;
            GridFirma.DataSource = new object[] { dc.Session };
    		colNuspTitle.Format = "REGON:";
            colNUSP.Format = string.Format("<strong>{0}</strong>", regon);
		}
        else
			GridFirma.Visible = daneFirmy;

        labelCopyright.EditValue = dc.Copyright;        
    }

	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}    

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
			<form id="form" method="post" runat="server">
			    <ea:datacontext id="dc" runat="server" oncontextload="dc_ContextLoad" RightMargin="-1" LeftMargin="-1" TypeName="Soneta.Place.Wyplata,Soneta.KadryPlace"></ea:datacontext>
				<small></small><u></u><b></b>
				<small>
<ea:TextGrid id="GridFirma" runat="server" RowTypeName="Soneta.Business.Session,Soneta.Business"
						WithSections="False" ShowHeader="None" RowsInRow="3" Pagination="False">
						<Columns>
							<ea:GridColumn RightBorder="None" Format="Nazwa firmy: " ID="colFirmaTitle" runat="server" Width="13"></ea:GridColumn>
							<ea:GridColumn RightBorder="None" Format="NIP:" ID="colNipTitle" runat="server"></ea:GridColumn>
							<ea:GridColumn RightBorder="None" Format="NUSP:" ID="colNuspTitle" runat="server"></ea:GridColumn>
							<ea:GridColumn BottomBorder="None" ID="colNazwaFirmy" runat="server" Width="69"></ea:GridColumn>
							<ea:GridColumn ID="colNIP" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="colNUSP" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Center" Format="|......................................|(pieczęć firmy)"
								ID="colStempel" RowSpan="3" VAlign="Bottom" runat="server"></ea:GridColumn>
						</Columns>
					</ea:TextGrid>
					<ea:TextGrid id="gridHeader" runat="server" onbeforerow="gridHeader_BeforeRow" RowTypeName="Soneta.Place.WyplataEtat, Soneta.KadryPlace"
						WithSections="False" ShowHeader="None" RowsInRow="10" Pagination="False">
						<Columns>
							<ea:GridColumn ID="GridColumn1" RightBorder="None" Format="Pracownik:" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn2" RightBorder="None" Format="Za okres:" runat="server"></ea:GridColumn>
							<ea:GridColumn ColSpan="5" BottomBorder="Single" ID="colPracInfo" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn3" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn4" Format="Podstawa:" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn5" Format="Ubezpieczony:" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn6" Format="Płatnik:" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optEmptyBegin" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optPodstawa" runat="server" Format="Podstawa:"></ea:GridColumn>
                            <ea:GridColumn ID="optSkladka" runat="server" Format="Składka:"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn7" ColSpan="4" DataMember="Pracownik" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn8" ColSpan="4" DataMember="ListaPlac.Okres" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn9" Align="Center" Format="Emerytalne" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn10" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Podstawa" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn11" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Prac" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn12" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Firma" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optFP" runat="server" Align="Center" Format="FP"></ea:GridColumn>
                            <ea:GridColumn ID="optFPPodstawa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FP.Podstawa" Format="{0:n}"></ea:GridColumn>
                            <ea:GridColumn ID="optFPSkladka" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FP.Firma" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn13" Align="Center" Format="Rentowe" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn14" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Podstawa" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn15" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Prac" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn16" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Firma" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optFGSP" runat="server" Align="Center" Format="FGŚP"></ea:GridColumn>
                            <ea:GridColumn ID="optFGSPPodstawa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FGSP.Podstawa" Format="{0:n}"></ea:GridColumn>
                            <ea:GridColumn ID="optFGSPSkladka" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FGSP.Firma" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn17" Align="Center" Format="Chorobowe" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn18" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Podstawa" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn19" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Prac" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn20" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Firma" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optFEP" runat="server" Align="Center" Format="FEP"></ea:GridColumn>
                            <ea:GridColumn ID="optFEPPodstawa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FEP.Podstawa" Format="{0:n}"></ea:GridColumn>
                            <ea:GridColumn ID="optFEPSkladka" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FEP.Firma" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn21" Align="Center" Format="Wypadkowe" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn22" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Podstawa" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn23" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Prac" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn24" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Firma" Format="{0:n}" runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="optEmptyEnd" runat="server" ColSpan="6" RowSpan="3"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn25" ColSpan="2" DataMember="Numer" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn26" RightBorder="None" Format="Oddział NFZ:" runat="server"></ea:GridColumn>
							<ea:GridColumn RightBorder="None" BottomBorder="Single" Format="Procent PIT:" ID="colPitInfo" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn27" Align="Center" Format="Razem" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn28" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn29" Align="Right" DataMember="Workers.WyplataSkładki.Razem.KosztyZUS" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn30" Align="Right" DataMember="Workers.WyplataSkładki.Razem.FirmaZUS" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn31" DataMember="PracHistoria.OddzialNFZ.Kod" runat="server"></ea:GridColumn>
							<ea:GridColumn BottomBorder="Single" DataMember="Workers.PITInfo.ProcentPit" ID="colPitProcent" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn32" Align="Center" Format="Zdrowotne" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn33" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Podstawa" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn34" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn35" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Firma" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn36" RightBorder="None" Format="Koszty uz.:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn37" RightBorder="None" Format="Ulga podatkowa:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn38" ID="GridColumn90" RightBorder="None" Format="Zdrow.do odlicz:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn39" RightBorder="None" Format="Zdrow. prac.:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn40" RightBorder="None" Format="Zal. podatku:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn41" RightBorder="None" Format="Gotówka:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn42" RightBorder="None" Format="ROR:" NoWrap="True" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn43" Align="Right" DataMember="Workers.PITInfo.KosztyFIS" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn44" Align="Right" DataMember="Workers.PITInfo.Ulga" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn45" ID="GridColumn100" Align="Right" DataMember="Workers.PITInfo.ZdrowotneDoOdliczenia" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn46" Align="Right" DataMember="Workers.PITInfo.ZdrowotnePracownika" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn47" Align="Right" DataMember="Workers.PITInfo.ZalFIS" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="colGotowka" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="colROR" runat="server"></ea:GridColumn>
						</Columns>
					</ea:TextGrid>
				<ea:textgrid id="gridElements" runat="server" WithSections="False" onbeforerow="gridElements_BeforeRow"
					DataMember="ElementyWgKolejności">
					<Columns>
						<ea:GridColumn Width="4" BottomBorder="None" Align="Right" DataMember="#" Caption="L.p."></ea:GridColumn>
						<ea:GridColumn BottomBorder="None" Total="Info" ID="colNazwa" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="Procent" HideZero="True" ID="colProcent"
							VAlign="Top"></ea:GridColumn>
						<ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="godz:min" HideZero="True"
							ID="colCzas"></ea:GridColumn>
						<ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="Dni" HideZero="True" ID="colDni"></ea:GridColumn>
						<ea:GridColumn Width="15" BottomBorder="None" Align="Right" Total="Sum" Caption="Dodatek" HideZero="True"
							Format="{0:n}" ID="colDodatek"></ea:GridColumn>
						<ea:GridColumn Width="15" BottomBorder="None" Align="Right" Total="Sum" Caption="Potrącenie" HideZero="True"
							Format="{0:n}" ID="colPotracenie"></ea:GridColumn>
						<ea:GridColumn Width="25" BottomBorder="None" Caption="Data i podpis"></ea:GridColumn>
					</Columns>
				</ea:textgrid>
				<ea:textgrid id="gridFundusze" runat="server" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="L.p."></ea:GridColumn>
						<ea:GridColumn Width="30" DataMember="Definicja.Nazwa" Caption="Fundusz" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Workers.FundPożyczkowy.Wkład" Caption="Wkład"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Workers.FundPożyczkowy.DoSpłaty" Caption="Do spłaty"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:textgrid>
			    <ea:datalabel id="labelCopyright" runat="server" Align="Right" WidthChars="130" Bold="False"></ea:datalabel>
			    </small>
			</form>
	</body>
</HTML>

